/**********************Document Ready****************************************/

$(document).ready(function(){
    
    /*****************************search details***************************/
    $("#search-input").keyup(function(e){
        var searchResult = $('.search-result');
        escape = function(text) {
              return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
        };
        var filter = escape($(this).val());
        searchdetails(filter);
        if($(this).val().length !== 0 ) {
			// search functions
			e.stopPropagation();
			searchResult.addClass('active');
		}else{
		    searchResult.removeClass('active');
		}
    });
    
    /*********************function search details***************************/
    
    function searchdetails(filter){
        $type = "getAlldetails";
        $.ajax({
            url: "assets/php/searchprofiledetails.php",
            method:"POST",
            dataType:"json",
            data:{
                "type":$type,
                "filter":filter
            },
            success:function(data){
                $('.getallnames').empty();
                $.each(data,function(i,row){
                    $flagpath = 'assets/img/flag-fetch/'+row[4]+'.png';
                    if(row[5] !== ""){
                        $profilepath = 'assets/uploads/'+row[6]+"/"+row[5];
                    }else{
                        $profilepath = 'assets/img/adminAllNew/profiletemplate.jpeg';
                    }
                    $('.getallnames').append(
                        '<li class="d-flex align-items-center justify-content-between eachprofilecheck">'+
                            '<div class="search-box d-flex align-items-center">'+
                                '<img src="'+$profilepath+'" alt="img">'+
                                '<div class="ml-2 search-details">'+
                                    '<h3>'+row[0]+" "+row[1]+"-"+row[2]+'</h3>'+
                                    '<span>'+row[3]+'</span>'+
                                '</div>'+
                            '</div>'+
                            '<div class="search-flag">'+
                                '<img src="'+$flagpath+'" alt="img">'+
                            '</div>'+
                        '</li>'
                    );
                });
            },
            error:function(data){
                $('.getallnames').empty();
                $('.search-result').removeClass('active');
            }
        });
    }
    
    /*********************function search details***************************/
    
    $(document).on('click','.eachprofilecheck',function(e) {
        $username = $(this).children('div').children('div').children('h3').text();
        $userprofile = $(this).children('div').children('div').children('span').text();
        geteachprofiledetails($username,$userprofile)
    });
    
    /*********************function get each profile***************************/
    
    function geteachprofiledetails(username,userprofile){
        $actiontyped = "geteachprofile";
        $.ajax({
            url: "assets/php/searchprofiledetails.php",
            method:"POST",
            dataType:"json",
            data:{
                "username":username,
                "userprofile":userprofile,
                "actiontype": $actiontyped
            },
            success:function(data){
                $userprofile = data['categorytype'];
                if($userprofile == "Prospect"){
                    $urltosend = "addprospect.php";
                    $actiontype = "prospectupdated&prospectview";
                    $pemail = data['pemail'];
                    $phno = data['pphno'];
                }else if($userprofile == "Student"){
                    $urltosend = "addstudent.php";
                    $actiontype = "studentupdated&studentview";
                    $pemail = data['pemail'];
                    $phno = data['pphno'];
                }else if($userprofile == "Teacher" || $userprofile == "Super Admin"){
                    $urltosend = "addteacher.php";
                    $actiontype = "teacherupdated&teacherview";
                    $pemail = data['email'];
                    $phno = data['pno'];
                }
                var url = ""+$urltosend+"?email="+ $pemail+"&phno="+$phno+"&action="+$actiontype;
                window.location.href = url;
                }
        });
    }
});