
/**********************Document Ready****************************************/

$(document).ready(function(){
    
    /***************************state selection***************************/
    
    let user_country_code = "AF";
    
    //let country_list = country_and_states['country'];
    let states_list = country_and_states['states'];
    
    create_states_dropdown(user_country_code);
    
    $('#country').on("change", function(){
      var countrycode = $(this).val();
      create_states_dropdown(countrycode);
      select_currency(countrycode)
    });
    
    
    /********************function state selection***************************/

    function create_states_dropdown(countrycode) {
        let states = states_list[countrycode];
        let option = '';
        $('#state-code').empty();
        if (states.length > 0) {
            $('#state-code').append('<option value="Choose">Choose State/Region</option>');
            for (let i = 0; i < states.length; i++) {
                $('#state-code').append('<option value="' + states[i].code + '">' + states[i].name + '</option>');
            }
        } else {
            $('#state-code').append('<option value="nooption">No State/Region Available</option>');
        }
        $('.countrypicker').selectpicker('refresh');
        $('.select-state_region').selectpicker('refresh');
    }
    
    /********************function currency selection***************************/
    
    function select_currency(countrycode) {
        //$("#currency option").prop("selected", false);
        $("#currency option").attr('selected', false);
        if(countrycode == "IN"){
            $currencycode = "INR";
        }else if(countrycode == "GB"){
            $currencycode = "GBP";
        }else if(countrycode == "GH"){
            $currencycode = "GHS";
        }else if(countrycode == "US"){
            $currencycode = "USD";
        }else if(countrycode == "CA"){
            $currencycode = "CAD";
        }else{
            $currencycode = "Choose";
        }
        $("#currency option[value='"+$currencycode+"']").attr('selected', 'selected');
        $('.currencyd').selectpicker('refresh');
    }
    
    /************************submit site config***************************/
     
     $("#sitesetup").on("submit",function(e){
        e.preventDefault();
        var form_data = new FormData(this);
        form_data.append("typed","insertupdate");
        sitedetails(form_data);
     });
    
    /********************function site config***************************/
    
    function sitedetails(formdata){
        $.ajax({
                url: "assets/php/siteconfigurationdetails.php",
                method:"POST",
                data:formdata,
                dataType:"JSON",
                processData:false,
                contentType:false,
                success:function(data){
                    $(".amsg").text(data);
                    if(data == "Information Registered!" || data == "Information Updated!"){
                        $("html").scrollTop(0);
                        $('.amsg').css({"color":"green"});
                        selectalldetails();
                    }
                }
        });
    }
    
    /********************function select all details***************************/
    
    selectalldetails();
    
    function selectalldetails(){
        $.ajax({
                url: "assets/php/siteconfigurationdetails.php",
                method:"POST",
                data:{alldetails:"getalldetails"},
                dataType:"JSON",
                success:function(data){
                     $("#country option[value='"+data['pcountry']+"']").attr('selected', 'selected');
                     create_states_dropdown(data['pcountry']);
                     $("#state-code option[value='"+data['pstate']+"']").attr('selected', 'selected');
                     $("#time_zone option[value='"+data['ptimezone']+"']").attr('selected', 'selected');
                     $("#currency option[value='"+data['pcurrencytype']+"']").attr('selected', 'selected');
                     if(data['whatsapp'] == "on"){
                          $('input[name="whatsapp"]').prop('checked', true);
                     }
                     if(data['email'] == "on"){
                          $('input[name="Email"]').prop('checked', true);
                     }
                     if(data['phone'] == "on"){
                          $('input[name="Phone"]').prop('checked', true);
                     }
                     $('.currencyd').selectpicker('refresh');
                     $('.countrypicker').selectpicker('refresh');
                     $('.select-state_region').selectpicker('refresh');
                     $('.select-time_zone').selectpicker('refresh');
                }
        });
    }
});