
/**********************Document Ready****************************************/

$(document).ready(function(){
    
    /*****************************Graph Data*********************************/
    
    $urldetails = $(location).attr('href');
    $searchd = "admin/addstudent";
    $searchp = "admin/progressreport";
    var today = new Date();
    var tday= today.getFullYear();
    
    if($urldetails.indexOf($searchd) != -1){
        displayratio();
        getAllStudent();
    }else if($urldetails.indexOf($searchp) != -1){
        $('.sSignups').text(tday);
        getAllProspect();
        getAllStudent();
        getAllRatiodetails()
        getAllClasses();
        //chart();
        /*****************************Go to Event*************************/
    
            $('.leftclick').on("click",function(){
                var prevyear = $('.sSignups').text();
                $('.sSignups').text(parseInt(prevyear)-1);
                getAllProspect();
                getAllStudent();
                getAllRatiodetails()
                getAllClasses();
            });
            
        /**************************Prospect Click*************************/
            
            $('.rightclick').on("click",function(){
                var nextyear = $('.sSignups').text();
                $('.sSignups').text(parseInt(nextyear)+1);
                getAllProspect();
                getAllStudent();
                getAllRatiodetails()
                getAllClasses();
            });
    }else{
        getAllRatiodetails()
        getAllClasses();
    }
        
    function displayprofilegraph(xlabels,ylabels,typed,catdetails){  
        const ctx = document.getElementById(typed).getContext('2d');
        const prospect_performance = new Chart(ctx, {
            type: 'bar',
            data: {
            //["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
            labels: xlabels,
            datasets: [{
                    label: catdetails,
                    data: ylabels,
                    backgroundColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(74, 173, 33, 1)',
                    'rgba(255, 159, 64, 1)',
                    'rgba(230, 238, 52, 1)',
                    'rgba(33, 215, 139, 1)',
                    'rgba(191, 0, 255, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(132, 99, 255, 1)',
                    'rgba(241, 31, 81, 1)'
                    ],
                    borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(74, 173, 33, 1)',
                    'rgba(255, 159, 64, 1)',
                    'rgba(230, 238, 52, 1)',
                    'rgba(33, 215, 139, 1)',
                    'rgba(191, 0, 255, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(132, 99, 255, 1)',
                    'rgba(241, 31, 81, 1)'
                    ],
                    borderWidth: 1
            }]
            },
            options: {
            scales: {
            xAxes: [{
                barThickness: 14,  // number (pixels) or 'flex'
                maxBarThickness: 20, // number (pixels)
                barPercentage: 0.5
            }],
            yAxes: [{
                ticks: {
                    beginAtZero: true,
                    suggestedMin: 0,
                    suggestedMax: 100
                }
            }]
            }
            }
            });
    }
    
    function displayratio($id,$classcount,$label){
        var ctxP = document.getElementById($id).getContext('2d');
        var myPieChart = new Chart(ctxP, {
        type: 'pie',
        plugins: [ChartDataLabels],
        data: {
        labels: $label,
        datasets: [{
        data: $classcount,
        backgroundColor: ["#F7464A", "#46BFBD", "#FDB45C", "#949FB1", "#3BA6DA"],
        hoverBackgroundColor: ["#FF5A5E", "#5AD3D1", "#FFC870", "#A8B3C5", "#616774"]
        }]
        },
        options: {
            responsive: true,
            aspectRatio: 1.1,
            legend: {
                  position: 'bottom',
                  labels: {
                    padding: 20,
                    boxWidth: 10
                  }
            },
            plugins: {
              datalabels: {
                formatter: (value, ctx) => {
                  let sum = 0;
                  let dataArr = ctx.chart.data.datasets[0].data;
                  dataArr.map(data => {
                    sum += data;
                  });
                  let percentage = Math.round((value * 100 / sum).toFixed(2)) + "%";
                  return percentage;
                },
                color: 'white',
                labels: {
                  title: {
                    font: {
                      size: '16'
                    }
                  }
                }
              }
            }
        }
        });
    }
    
    function displayAllcategory($id,$classcount,$label){
        var ctxP = document.getElementById($id).getContext('2d');
        var myPieChart = new Chart(ctxP, {
          plugins: [ChartDataLabels],
          type: 'doughnut',
          data: {
            labels: $label,
            datasets: [{
              data: $classcount,
              backgroundColor: ["#F7464A", "#46BFBD", "#FDB45C"],
              hoverBackgroundColor: ["#FF5A5E", "#5AD3D1", "#FFC870"]
            }]
          },
          options: {
            responsive: true,
            cutoutPercentage: 50,
            aspectRatio: 1,
            radius:80,
            legend: {
              position: 'bottom',
              labels: {
                padding: 20,
                boxWidth: 10
              }
            },
            plugins: {
              datalabels: {
                formatter: (value, ctx) => {
                  let sum = 0;
                  let dataArr = ctx.chart.data.datasets[0].data;
                  dataArr.map(data => {
                    sum += data;
                  });
                  let percentage = Math.round((value * 100 / sum).toFixed(2)) + "%";
                  return percentage;
                },
                color: 'white',
                labels: {
                  title: {
                    font: {
                      size: '16'
                    }
                  }
                }
              }
            }
          }
        });
    }
    
    function chart(){
        var ctxP = document.getElementById("labelChart").getContext('2d');
        var myPieChart = new Chart(ctxP, {
          plugins: [ChartDataLabels],
          type: 'pie',
          data: {
            labels: ["Prospect", "Student", "Teacher"],
            datasets: [{
              data: [210, 130, 120],
              backgroundColor: ["#F7464A", "#46BFBD", "#FDB45C"],
              hoverBackgroundColor: ["#FF5A5E", "#5AD3D1", "#FFC870"]
            }]
          },
          options: {
            responsive: true,
            legend: {
              position: 'right',
              labels: {
                padding: 20,
                boxWidth: 10
              }
            },
            plugins: {
              datalabels: {
                formatter: (value, ctx) => {
                  let sum = 0;
                  let dataArr = ctx.chart.data.datasets[0].data;
                  dataArr.map(data => {
                    sum += data;
                  });
                  let percentage = (value * 100 / sum).toFixed(2) + "%";
                  return percentage;
                },
                color: 'white',
                labels: {
                  title: {
                    font: {
                      size: '16'
                    }
                  }
                }
              }
            }
          }
        });
    }
        
    /*****************************Display prospect*************************/
    
    function getAllProspect(){
        const xlabels=[];
        const ylabels=[];
        $type = "Prospect";
        $dor = $('.sSignups').text();
        $.ajax({
            url: "assets/php/preport.php",
            method:"POST",
            dataType:"json",
            data:{
                "type":$type,
                "yeard": $dor
            },
            success:function(data){
                $.each(data,function(i,row){
                    $.each(row,function(id,rowd){
                        $monthd = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                        $month = $monthd[id];
                        xlabels.push($month);
                        $prospectd = rowd;
                        ylabels.push($prospectd);
                        $typed = "prospect_performance";
                        $type = 'Prospect';
                        //console.log($month+":"+$prospectd);
                    });
                    displayprofilegraph(xlabels,ylabels,$typed,$type);
                });
            },
            error:function(data){
                $monthd = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                $prospectd = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
                $typed = "prospect_performance";
                $type = 'Prospect';
                displayprofilegraph($monthd,$prospectd,$typed,$type);
            }
        });
    }
    
    
    /*****************************Display prospect*************************/
    
    function getAllClasses(){
        $type = "Get class details";
        $dor = $('.sSignups').text();
        $.ajax({
            url: "assets/php/preport.php",
            method:"POST",
            dataType:"json",
            data:{
                "type":$type,
                "yeard": $dor
            },
            success:function(data){
                $classcount = data.split("##");
                $id = "getChart";
                $class1 = Math.round(($classcount[0]/(parseInt($classcount[0])+parseInt($classcount[1])+parseInt($classcount[2])))*100);
                $class2 = Math.round(($classcount[1]/(parseInt($classcount[0])+parseInt($classcount[1])+parseInt($classcount[2])))*100);
                $class3 = Math.round(($classcount[2]/(parseInt($classcount[0])+parseInt($classcount[1])+parseInt($classcount[2])))*100);
                $classcount = [$class1,$class2,$class3];
                $label = ['Completed Class(%)', 'Not Completed Class(%)','Cancelled Class(%)'];
                displayAllcategory($id,$classcount,$label);
            },
            error:function(data){
                $id = "getChart";
                $classcount = [0,0,0];
                $label = ['Completed Class(%)', 'Not Completed Class(%)','Cancelled Class(%)'];
                displayAllcategory($id,$classcount,$label);
            }
        });
    }
    
    /*****************************Display prospect*************************/
    
    function getAllRatiodetails(){
        $type = "Get prospect student";
        $dor = $('.sSignups').text();
        $.ajax({
            url: "assets/php/preport.php",
            method:"POST",
            dataType:"json",
            data:{
                "type":$type,
                "yeard": $dor
            },
            success:function(data){
                $classcount = data.split("##");
                $id = "newpieChart";
                $class1 = Math.round(($classcount[0]/(parseInt($classcount[0])+parseInt($classcount[1])))*100);
                $class2 = Math.round(($classcount[1]/(parseInt($classcount[0])+parseInt($classcount[1])))*100);
                $classcount = [$class1,$class2];
                $label = ['Prospects(%)', 'Students(%)'];
                displayratio($id,$classcount,$label);
            },
            error:function(data){
                $id = "newpieChart";
                $classcount = [0,0];
                $label = ['Prospects(%)', 'Students(%)'];
                displayratio($id,$classcount,$label);
            }
        });
    }
    
    /*****************************Display student*************************/
    
    function getAllStudent(){
        const xlabels=[];
        const ylabels=[];
        $type = "Student";
        $dor = $('.sSignups').text();
        $.ajax({
            url: "assets/php/preport.php",
            method:"POST",
            dataType:"json",
            data:{
                "type":$type,
                "yeard": $dor
            },
            success:function(data){
                $.each(data,function(i,row){
                    $.each(row,function(id,rowd){
                        $monthd = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                        $month = $monthd[id];
                        xlabels.push($month);
                        $prospectd = rowd;
                        ylabels.push($prospectd);
                        $typed = "student_performance";
                        $type = 'Student';
                    });
                    displayprofilegraph(xlabels,ylabels,$typed,$type);
                });
            },
            error:function(data){
                $monthd = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                $prospectd = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
                $typed = "student_performance";
                $type = 'Student';
                displayprofilegraph($monthd,$prospectd,$typed,$type);
            }
        });
    }
    
});